//Note: Details of scilab software version and OS version used:
//Tested on OS: Windows 7 SP1, 64 bit and Windows XP SP3, 32 bit
//Scilab version: 5.4.1 (Tested on both 32 bit and 64 bit versions)
//Program Title: Study and generate MSK waveforms (PSK Approach)

clear;
clc;
close;
h=1/2;
T=1;// One symbol period
t = 0:0.01:T; // One symbol period vector
f=1; // Carrier cycles per symbol period "t"
//I=[0 1 0 1 0 1 0 1]; //data stream in binary to test worst case
I=[0 0 0 1 1 0 1 1]; //data stream giving dibits equivalent to 0,1,2,3

//PNRZ Converter, converts data to PNRZ (Bi-Polar Signal)
    I_PNRZ = [] //empty matrix for PNRZ data
        for n = 1:length(I)
            if I(n)== 0 then
                I_PNRZ = [I_PNRZ, -1]
            else
                I_PNRZ = [I_PNRZ, 1]
            end
        end

//Generation of MSK Waveform using PSK approach

theta=0;//Initial phase in radians

z=0;//Starting point of plot on x-axis

for n=1:1:length(I_PNRZ)
    subplot(3,1,1) //Data Plot
        a=gca();
        a.data_bounds=[0,-1.5;length(I_PNRZ),1.5]; //set the boundary values for the x-y coordinates.
        a.x_location="origin";
        a.grid=[1,-1];
        title('Data')
            plot((t+z),I_PNRZ(n));
            
    subplot(3,1,2) //MSK Plot
        a=gca();
        a.data_bounds=[0,-1.5;length(I_PNRZ),1.5]; //set the boundary values for the x-y coordinates.
        a.x_location="origin";
        a.grid=[1,-1];
        title('MSK')
            theta_change = theta + ((I_PNRZ(n))*((%pi*h*t)/T));//Phase variation over a bit period
            plot((t+z),sqrt(2/T)*cos(2*%pi*f*t + theta_change)); // MSK Plot
            plot((t+z),sqrt(2/T)*cos(2*%pi*f*t),'r'); // Carrier for reference
            
    subplot(3,1,3) // Plot for MSK Phase variation wrt Carrier
        a=gca();
        a.x_location="bottom";
        a.grid=[1,1];
        title('MSK Phase variation wrt Carrier')
        theta_degrees = theta_change*(180/%pi);//converts radians to degrees
            plot((t+z),theta_degrees);// plote phase variation for a bit period
            
theta=theta_change(length(theta_change));//Stores last value of phase to theta 
z=z+1;//Move starting point of plot on x-axis by 1 bit period
//xpause(2000000);   //Delay for observation      
end

